PACKAGE ap IS
  SUBTYPE alt IS INTEGER RANGE 0 TO 50000;
  SUBTYPE hdg IS INTEGER RANGE 0 TO 359;
  SUBTYPE vdir IS INTEGER RANGE 0 TO 9;
  SUBTYPE hdir IS INTEGER RANGE 0 TO 9;
  SUBTYPE control IS INTEGER RANGE 0 TO 9;
END ap;
---------------------------------------------------------
-- added to make below compile
---------------------------------------------------------
use work.ap.all;
entity alt_compare is
    PORT( alt_ref : IN alt;
          alt_ind : IN alt;
          up_down : OUT vdir);
end alt_compare;
architecture behave of alt_compare is
begin
end behave;

configuration alt_comp_con of alt_compare is
  for behave
  end for;
end alt_comp_con;
    

use work.ap.all;
entity hdg_compare is
    PORT( hdg_ref : IN hdg;
          hdg_ind : IN hdg;
          left_right : OUT hdir);
end hdg_compare;
architecture behave of hdg_compare is
begin
end behave;

configuration hdg_comp_con of hdg_compare is
  for behave
  end for;
end hdg_comp_con;

use work.ap.all;
entity hdg_ctrl is
    PORT( left_right : IN hdir;
          rdr : OUT control;
          alrn : OUT control);
end hdg_ctrl;
architecture behave of hdg_ctrl is
begin
end behave;

configuration hdg_ctrl_con of hdg_ctrl is
  for behave
  end for;
end hdg_ctrl_con;

use work.ap.all;
entity alt_ctrl is
    PORT( up_down : IN vdir;
          elevator : OUT control);
end alt_ctrl;
architecture behave of alt_ctrl is
begin
end behave;

configuration alt_ctrl_con of alt_ctrl is
  for behave
  end for;
end alt_ctrl_con;
--------------------------------------------------------
  
PACKAGE ap IS
  SUBTYPE alt IS INTEGER RANGE 0 TO 50000;
  SUBTYPE hdg IS INTEGER RANGE 0 TO 359;
  SUBTYPE vdir IS INTEGER RANGE 0 TO 9;
  SUBTYPE hdir IS INTEGER RANGE 0 TO 9;
  SUBTYPE control IS INTEGER RANGE 0 TO 9;
END ap;

USE WORK.ap.ALL;
ENTITY autopilot IS
  PORT( altitude : IN alt;
        altitude_set : IN alt;
        heading : IN hdg;
        heading_set : IN hdg;
        rudder : OUT control;
        aileron : OUT control;
        elevator : OUT control);
END autopilot; 

ARCHITECTURE block_level OF autopilot IS
  COMPONENT alt_compare
    PORT( alt_ref : IN alt;
          alt_ind : IN alt;
          up_down : OUT vdir);
  END COMPONENT;    

  COMPONENT hdg_compare
    PORT( hdg_ref : IN hdg;
          hdg_ind : IN hdg;
          left_right : OUT hdir);
  END COMPONENT;

  COMPONENT hdg_ctrl
    PORT( left_right : IN hdir;
          rdr : OUT control;
          alrn : OUT control);
  END COMPONENT;

  COMPONENT alt_ctrl
    PORT( up_down : IN vdir;
          elevator : OUT control);
  END COMPONENT;

  SIGNAL up_down : vdir;
  SIGNAL left_right : hdir;

  FOR M1 : alt_compare USE CONFIGURATION WORK.alt_comp_con;

  FOR M2 : hdg_compare USE CONFIGURATION WORK.hdg_comp_con;

  FOR M3 : hdg_ctrl USE ENTITY WORK.hdg_ctrl(behave);
   
  FOR M4 : alt_ctrl USE ENTITY WORK.alt_ctrl(behave); 

BEGIN    
  M1 : alt_compare         
    PORT MAP( alt_ref => altitude, 
              alt_ind => altitude_set,
              up_down => up_down);

  M2 : hdg_compare
    PORT MAP( hdg_ref => heading, 
              hdg_ind => heading_set,
              left_right => left_right);

  M3 : hdg_ctrl
    PORT MAP( left_right => left_right, 
              rdr => rudder,
              alrn => aileron);

  M4 : alt_ctrl
    PORT MAP( up_down => up_down, 
              elevator => elevator);
 
END block_level;





